#define INTERVAL 700
int clkPin = 16;
int sftApin = 17;
int decApin = 9;
int decBpin = 18;
int decCpin = 19;
char data[][8] ={
  {0x20,0xF0,0x2E,0x40,0x48,0x50,0x8E,0x0},
  {0x2A,0xF0,0x2E,0x40,0x48,0x50,0x8E,0x0},
  {0x10,0x28,0xDE,0x0,0x7C,0x8,0x30,0x0},
  {0x54,0xFE,0xAA,0x38,0x10,0x7C,0x7C,0x0},
  {0xAA,0xFE,0x28,0x7C,0xFE,0x38,0xD6,0x0},
  {0x10,0xFE,0x92,0x92,0xFE,0x10,0x10,0x0},
  {0xE,0x74,0xA,0x10,0x10,0x8,0x6,0x0},
  {0x8,0xFE,0x18,0x28,0x18,0x8,0x10,0x0},
  {0x10,0x10,0x10,0x10,0x10,0x0,0x10,0x0},
  {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}
};
int moji = 0, cnt;
unsigned pre;

void setup() {
  pinMode(clkPin, OUTPUT);
  pinMode(sftApin, OUTPUT);
  pinMode(decApin, OUTPUT);
  pinMode(decBpin, OUTPUT);
  pinMode(decCpin, OUTPUT);
  cnt = sizeof(data)/sizeof(data[0]);
  pre = millis();
}

void loop() {
  unsigned m = millis();
  if (m - pre > INTERVAL){                // INTERVAL時間経過したら次の文字
    pre = m;
    moji = moji < cnt-1 ? moji+1: 0;
  }
  ledMoji(moji);
}

void ledMoji(int d) {
  for (int j = 0; j < 8; j++) {
    byte v = data[d][j];
    digitalWrite(decApin, j & 1);
    digitalWrite(decBpin, j & 2);
    digitalWrite(decCpin, j & 4);
    for (int i = 0; i < 9; i++) {
      digitalWrite(clkPin, HIGH);
//      digitalWrite(sftApin, v & (1 << i));  // 文字が左右逆に表示されるので変更
      digitalWrite(sftApin, v & (0x80 >> i));
      digitalWrite(clkPin, LOW);
    }
    delay(3);
  }
}

