/*
    HS15P を使った湿度計の実験 
      http://www.surveytec.com/ 
    *** 参考URL　http://homepage3.nifty.com/sudamiyako/zk/hs15/hs15.htm
*/
#include <LiquidCrystal.h>
#include <Time.h>

int outPin = 8;    // HS15P への給電
int ondPin = 0;    // LM35 からの入力
int humPin = 1;    // コンデンサからの入力
LiquidCrystal lcd(7, 6, 5, 4, 3, 2);  // LCD ピンアサイン変更

const unsigned int LogTbl[]={        //  アナログレベル変換テーブル
  34,36,38,40,42,44,47,49,52,55,57,60,64,67,70,
  74,77,81,85,89,93,98,102,107,111,116,121,126,
  131,137,142,147,153,158,163,169,174,180,185,190};
time_t time = now();

void setup() {
  analogReference(DEFAULT);
  pinMode(outPin, OUTPUT);
  digitalWrite(outPin, LOW);
  Serial.begin(9600);
  lcd.begin(16, 2);
  lcd.noCursor();
  delay(100);
}

void loop() {
  int i, j, r, Tm = 0 ;
  double Rs, hum, ond;
  
  // 温度計測　50回の平均を取る
  analogRead(ondPin);
  for (i = 0; i < 50; i++) {
    Tm += analogRead(ondPin);
  }
  ond = (double)(Tm) / 50 * 5.0 / 1024.0 * 100.0;

  // 湿度計測　時間 5us->50->500...
  unsigned long t = 5;
  for(i = 0; i < 5; i++){
    r = getRs(t);
    Rs = 200 - i * 40 + r;
    if (r) break;
    t *= 10;
  }

  // 温度補正
  Rs += (Rs * 35.0 - 13056.0) / 64.0 * ond / 64.0;
  Rs = Rs < 0 ? 0: Rs;
  //	リニアリティ補正(近似式)
  hum= (5.0 * Rs / 16.0 * Rs + 44 * Rs ) / 256.0 + 20.0;

  // 結果表示
  Serial.print("Temperature=");    //  温度
  Serial.println(ond);
  Serial.print("Humidity=");      //  湿度
  Serial.println(hum);
  Serial.println("---");
  lcdDisp(ond, hum);
  delay(1000);
}

unsigned char getRs(unsigned long chgTime) {
  int i, j;
  digitalWrite(outPin, LOW);
  // 放電・アナログ入力がある間待つ
  for (i = 0; i < 1000; i++) {
    if(analogRead(humPin) < 10) break;
    delayMicroseconds(1);
  }
  // 測定開始:充電
  pinMode(outPin, OUTPUT);
  digitalWrite(outPin, HIGH);
  for (i = 0 ; i < chgTime; i++) {
    delayMicroseconds(2);
  }
  digitalWrite(outPin, LOW);
  // アナログからの入力(2ビット右シフト)
  j = analogRead(humPin) >> 2;
  for(i = 0; i < 40; i++){
    if (j < LogTbl[i])
      break;
  }
  // テーブルのインデックスを返す
  return i;
}

void lcdDisp(double o, double h) {
  char str[17];

  lcd.clear();
  lcd.setCursor(0, 0);
  sprintf(str, "%02d %02d:%02d:%02d", day(), hour(), minute(), second());
  lcd.print(str);

  lcd.setCursor(0, 1);
  lcd.print(o, 0);
  lcd.write(0xDF);
  lcd.print("C ");
  lcd.print(h, 0);
  lcd.print("%");
}







