#define INTERVAL 100
int clkPin = 8;
int aPin = 9;

void setup() {
  pinMode(clkPin, OUTPUT);
  pinMode(aPin, OUTPUT);
  ledClear();
}

void loop() {
  int i, j, v;
  
  for (j = 0; j < 1; j++) {
    for (i = 0; i <= 8; i++) {
      ledDigit(1 << i);
    }
    for (i = 0; i <= 8; i++) {
      ledDigit(0x80 >> i);
    }
  }

  for (j = 0; j < 1; j++) {
    v = 0;
    for (i = 0; i < 8; i++) {
      v += 1 << i;
      ledDigit(v);
    }
    for (i = 0; i < 8; i++) {
      ledDigit(v >> i + 1);
    }
  }

  for (j = 0; j < 1; j++) {
    v = 0;
    for (i = 0; i < 8; i++) {
      v += 1 << i;
      ledDigit(v);
    }
    for (i = 0; i < 8; i++) {
      v -= 1 << i;
      ledDigit(v);
    }
  }

  for (j = 0; j < 8; j++) {
    ledDigit(0b10001000);
    ledDigit(0b01000100);
    ledDigit(0b00100010);
    ledDigit(0b00010001);
  }

}

void ledClear() {
  digitalWrite(aPin,HIGH);
  for(int i = 0; i < 9; i++){
    digitalWrite(clkPin,LOW);
    delayMicroseconds(1);
    digitalWrite(clkPin,HIGH);
    delayMicroseconds(1);
  }
}

void ledDigit(int d) {
  ledClear();
  for (int i = 0; i < 9; i++) {
    digitalWrite(clkPin, HIGH);
    digitalWrite(aPin, ~d & (1 << i));
    delayMicroseconds(1);
    digitalWrite(clkPin, LOW);
    delayMicroseconds(1);
  }
  delay(INTERVAL);
}

