unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ActPBox;

type
  TForm1 = class(TForm)
    Image1: TImage;
    ActPBox: TActPBox;
    Panel1: TPanel;
    BurstOut: TButton;
    BurstIn: TButton;
    WheelIn: TButton;
    WheelOut: TButton;
    ZoomIn: TButton;
    ZoomOut: TButton;
    Sample: TButton;
    MosaicOut: TButton;
    MosaicIn: TButton;
    CirWipeIn: TButton;
    CirWipeOut: TButton;
    SpotOut: TButton;
    SpotIn: TButton;
    SpotMove: TButton;
    SpinVir: TButton;
    SpinHor: TButton;
    RollUp: TButton;
    RollLeft: TButton;
    RollDown: TButton;
    RollRight: TButton;
    procedure BurstOutClick(Sender: TObject);
    procedure BurstInClick(Sender: TObject);
    procedure WheelInClick(Sender: TObject);
    procedure WheelOutClick(Sender: TObject);
    procedure ZoomInClick(Sender: TObject);
    procedure ZoomOutClick(Sender: TObject);
    procedure SampleClick(Sender: TObject);
    procedure MosaicOutClick(Sender: TObject);
    procedure MosaicInClick(Sender: TObject);
    procedure ActPBoxEffectEnd(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CirWipeInClick(Sender: TObject);
    procedure CirWipeOutClick(Sender: TObject);
    procedure SpotOutClick(Sender: TObject);
    procedure SpotInClick(Sender: TObject);
    procedure SpotMoveClick(Sender: TObject);
    procedure SpinVirClick(Sender: TObject);
    procedure SpinHorClick(Sender: TObject);
    procedure RollUpClick(Sender: TObject);
    procedure RollLeftClick(Sender: TObject);
    procedure RollDownClick(Sender: TObject);
    procedure RollRightClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    ScrIdx: Integer;
    ScrEf: array [0..20] of Integer;
    ScrStep: array [0..20] of Integer;
    ScrFile: array [0..20] of String;
    ret: Boolean;
  end;

var
  Form1: TForm1;


implementation

{$R *.DFM}


procedure TForm1.BurstOutClick(Sender: TObject);
begin
  ActPBox.TipSize := 5;
  ActPBox.Step := 50;
  ActPBox.BurstOut;
end;

procedure TForm1.BurstInClick(Sender: TObject);
begin
  ActPBox.TipSize := 5;
  ActPBox.Step := 50;
  ActPBox.BurstIn;
end;

procedure TForm1.WheelInClick(Sender: TObject);
begin
  ActPBox.TipSize := 5;
  ActPBox.EndRate := 4;
  ActPBox.Step := 50;
  ActPBox.WheelIn;
end;

procedure TForm1.WheelOutClick(Sender: TObject);
begin
  ActPBox.TipSize := 5;
  ActPBox.Step := 50;
  ActPBox.WheelOut;
end;

procedure TForm1.ZoomInClick(Sender: TObject);
begin
  ActPbox.EndRate := 2;
  ActPBox.Step := 30;
  ActPBox.ZoomIn;
end;

procedure TForm1.ZoomOutClick(Sender: TObject);
begin
  ActPbox.EndRate := 2;
  ActPBox.Step := 30;
  ActPBox.ZoomOut;
end;

procedure TForm1.CirWipeInClick(Sender: TObject);
begin
  ActPBox.Step := 30;
  ActPBox.CirWipeIn;
end;

procedure TForm1.CirWipeOutClick(Sender: TObject);
begin
  ActPBox.Step := 30;
  ActPBox.CirWipeOut;
end;

procedure TForm1.MosaicOutClick(Sender: TObject);
begin
  ActPBox.TipSize := 20;
  ActPBox.Step := 10;
  ActPBox.MosaicOut;
end;

procedure TForm1.MosaicInClick(Sender: TObject);
begin
  ActPBox.TipSize := 20;
  ActPBox.Step := 10;
  ActPBox.MosaicIn;
end;

procedure TForm1.SpotOutClick(Sender: TObject);
begin
  ActPBox.TipSize := 10;
  ActPBox.Step := 50;
  ActPBox.SpotOut;
end;

procedure TForm1.SpotInClick(Sender: TObject);
begin
  ActPBox.TipSize := 10;
  ActPBox.Step := 50;
  ActPBox.SpotIn;
end;

procedure TForm1.SpotMoveClick(Sender: TObject);
begin
  ActPBox.TipSize := 20;
  ActPBox.Step := 100;
  ActPBox.SpotMove;
end;

procedure TForm1.SpinVirClick(Sender: TObject);
begin
  ActPBox.TipSize := 5;
  ActPBox.Step := 42;
  ActPBox.SpinVir;
end;

procedure TForm1.SpinHorClick(Sender: TObject);
begin
  ActPBox.TipSize := 10;
  ActPBox.Step := 42;
  ActPBox.SpinHor;
end;

procedure TForm1.RollUpClick(Sender: TObject);
begin
  ActPBox.TipSize := 5;
  ActPBox.Step := 50;
  ActPBox.RollUp;
end;

procedure TForm1.RollLeftClick(Sender: TObject);
begin
  ActPBox.TipSize := 5;
  ActPBox.Step := 50;
  ActPBox.RollLeft;
end;

procedure TForm1.RollDownClick(Sender: TObject);
begin
  ActPBox.TipSize := 5;
  ActPBox.Step := 50;
  ActPBox.RollDown;
end;

procedure TForm1.RollRightClick(Sender: TObject);
begin
  ActPBox.TipSize := 5;
  ActPBox.Step := 50;
  ActPBox.RollRight;
end;

procedure TForm1.SampleClick(Sender: TObject);
begin
  ScrEf[0] :=  1;    ScrStep[0] := 50;     ScrFile[0] := 'goodnews.bmp';
  ScrEf[1] := 13;    ScrStep[1] := 20;     ScrFile[1] := '';
  ScrEf[2] := 12;    ScrStep[2] := 20;     ScrFile[2] := 'testimage.bmp';
  ScrEf[3] := 14;    ScrStep[3] := 50;     ScrFile[3] := '';
  ScrEf[4] := 15;    ScrStep[4] := 50;     ScrFile[4] := '';
  ScrEf[5] :=  6;    ScrStep[5] := 20;     ScrFile[5] := '';
  ScrEf[6] :=  5;    ScrStep[6] := 30;     ScrFile[6] := 'earth.bmp';
  ScrEf[7] := 11;    ScrStep[7] := 30;     ScrFile[7] := '';
  ScrEf[8] := 20;    ScrStep[8] := 10;     ScrFile[8] := '';
  ScrEf[9] := 10;    ScrStep[9] := 30;     ScrFile[9] := 'roll.bmp';
  ScrEf[10]:= 16;    ScrStep[10]:= 60;     ScrFile[10]:= '';
  ScrEf[11]:=  7;    ScrStep[11]:= 80;     ScrFile[11]:= 'scroll.bmp';
  ScrEf[12]:= 18;    ScrStep[12]:= 80;     ScrFile[12]:= '';
  ScrEf[13]:=  4;    ScrStep[13]:= 50;     ScrFile[13]:= '';
  ScrIdx := 0;
  ActPBox.EndRate := 1;
  ActPBoxEffectEnd(Self);
end;

procedure TForm1.ActPBoxEffectEnd(Sender: TObject);
begin
  if ScrIdx <= High(ScrEf) then begin
    if ScrFile[ScrIdx] <> '' then
      Image1.Picture.Bitmap.LoadFromFile(ScrFile[ScrIdx]);
    ActPBox.Step   := ScrStep[ScrIdx];
    ActPBox.TipSize := 5;
    case ScrEf[ScrIdx] of
      1 : ActPBox.WheelIn;
      2 : ActPBox.WheelOut;
      3 : ActPBox.BurstIn;
      4 : ActPBox.BurstOut;
      5 : ActPBox.SpotIn;
      6 : ActPBox.SpotOut;
      7 : begin
            ActPBox.TipSize := 20;
            ActPBox.SpotMove;
          end;
      8 : ActPBox.MosaicIn;
      9 : ActPBox.MosaicOut;
     10 : ActPBox.CirWipeIn;
     11 : ActPBox.CirWipeOut;
     12 : ActPBox.ZoomIn;
     13 : ActPBox.ZoomOut;
     14 : ActPBox.SpinVir;
     15 : ActPBox.SpinHor;
     16 : ActPBox.RollUp;
     17 : ActPBox.RollDown;
     18 : ActPBox.RollLeft;
     19 : ActPBox.RollRight;
     20 : ActPBox.Wait;
    end;
  end  else  begin
  end;
  Inc(ScrIdx);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ScrIdx := 99;
end;

end.
